//
//  CSVersion.h
//  CSUpdate
//
//  Created by Alastair Houghton on 11/01/2006.
//  Copyright 2006 Coriolis Systems Limited. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
  CSDevelopmentVersionStatus,
  CSAlphaVersionStatus,
  CSBetaVersionStatus,
  CSFinalVersionStatus
} CSVersionStatus;

@interface CSVersion : NSObject
{
  NSString        *majorVersion;
  NSArray         *minorVersions;
  CSVersionStatus versionStatus;
  NSString        *buildNumber;

  double          realVersion;
  BOOL            gotRealVersion;
}

+ (CSVersion *)versionFromString:(NSString *)string;
+ (CSVersion *)versionFromInfo:(NSDictionary *)info;
+ (CSVersion *)OSXVersion;
+ (CSVersion *)leopardOSXVersion;
+ (CSVersion *)lionOSXVersion;
+ (CSVersion *)mountainLionOSXVersion;

- (id)initWithString:(NSString *)string;

- (NSString *)majorVersion;
- (NSArray *)minorVersions;
- (CSVersionStatus)versionStatus;
- (NSString *)buildNumber;

- (double)realVersion;
- (BOOL)gotRealVersion;

- (NSComparisonResult)compare:(CSVersion *)otherVersion;

- (NSString *)description;
- (NSString *)stringValue;

@end

/*
 * Local Variables:
 * mode: objc
 * End:
 *
 */
